<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    use HasFactory;

    protected $table = 'bbm_clients';

    protected $fillable = [
        'name',
        'email',
        'phone',
        'billing_address',
        'shipping_address',
        'currency',
        'tax_id',
        'status'
    ];

    protected $casts = [
        'billing_address' => 'array',
        'shipping_address' => 'array',
    ];

    // Relationships
    public function invoices()
    {
        return $this->hasMany(Invoice::class, 'client_id');
    }

    public function contacts()
    {
        return $this->hasMany(Contact::class, 'client_id');
    }
}
