<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    protected $table = 'bbm_invoices';

    protected $fillable = [
        'invoice_no',
        'client_id',
        'ls_order_id',
        'status',
        'currency',
        'subtotal',
        'tax_total',
        'discount_total',
        'total',
        'amount_paid',
        'balance_due',
        'issued_date',
        'due_date',
        'notes',
        'json_payload',
        'pdf_path'
    ];

    protected $casts = [
        'json_payload' => 'array',
        'issued_date' => 'date',
        'due_date' => 'date',
    ];

    // Relationships
    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }

    public function items()
    {
        return $this->hasMany(InvoiceItem::class, 'invoice_id');
    }

    public function payments()
    {
        return $this->hasMany(Payment::class, 'invoice_id');
    }
}
